package de.duehl.vocabulary.japanese.common.persistence;

import java.awt.Color;

/**
 * Dieses Interface bietet Methoden zu den Farben an, die man braucht, um bestimmte Teile der
 * Vokabel darzustellen.
 *
 * Hier geht es dabei um die Farben der Kana und der Kanji.
 *
 * @version 1.01     2024-08-15
 * @author Christian Dühl
 */

public interface KanjiAndKanaColorOptions {

    /** Getter für die Farbe für normalen Text bei der Darstellung einer Vokabel. */
    Color getVocableColorStandard();

    /** Getter für die Farbe für Kanji bei der Darstellung einer Vokabel. */
    Color getVocableColorKanji();

    /** Getter für die Farbe für Kana bei der Darstellung einer Vokabel. */
    Color getVocableColorKana();

}
