package de.duehl.vocabulary.japanese.common.persistence;

import java.awt.Color;

/**
 * Dieses Interface bietet Methoden zu den Farben an, die man braucht, um bestimmte Teile der
 * Vokabel darzustellen.
 *
 * Hier geht es dabei um die Farben der Übersetzung, des Kommentars und der Beschreibung des
 * Vokabulars.
 *
 * @version 1.01     2024-08-15
 * @author Christian Dühl
 */

public interface TranslationCommentAndVocabularyDescriptionColorOptions {

    /** Getter für die Farbe für normalen Text bei der Darstellung einer Vokabel. */
    Color getVocableColorStandard();

    /** Getter für die Farbe für die Übersetzung bei der Darstellung einer Vokabel. */
    Color getVocableColorTranslation();

    /** Getter für die Farbe für den Kommentar bei der Darstellung einer Vokabel. */
    Color getVocableColorComment();

    /** Getter für die Farbe für einen Suchbegriff bei der Darstellung einer Vokabel. */
    Color getVocableColorSearchWords();

    /** Getter für die Farbe für eine Wortart bei der Darstellung einer Vokabel. */
    Color getVocableColorPartOfSpeach();

}
