package de.duehl.vocabulary.japanese.io;

import java.util.List;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.vocabulary.japanese.data.KanjiSet;

/**
 * Diese Klasse liest eine (Teil-) Menge von Kanji, die der Benutzer definiert hat, aus einer
 * Datei.
 *
 * @version 1.01     2024-11-24
 * @author Christian Dühl
 */

public class KanjiSetReader {

    /** Liest eine Kanji-Menge aus der übergebenen Datei ein. */
    public static KanjiSet read(String filename) {
        List<String> lines = FileHelper.readFileToList(filename, Charset.UTF_8);

        if (lines.isEmpty()) {
            throw new RuntimeException("Die Datei '" + filename + "' ist leer.");
        }
        String name = lines.remove(0);
        KanjiSet kanjiSet = new KanjiSet(name);

        if (lines.isEmpty()) {
            throw new RuntimeException(
                    "Die Datei '" + filename + "' enthält keine Zeile für die Gruppe.");
        }
        String group = lines.remove(0);
        kanjiSet.setGroup(group);

        for (String line : lines) {
            if (!line.isBlank()) {
                String character = line.strip();
                kanjiSet.addKanji(character);;
            }
        }

        return kanjiSet;
    }

}
