package de.duehl.vocabulary.japanese.statistics.data;

import de.duehl.vocabulary.japanese.data.symbol.Kanji;

public class KanjiWithCounter {

    private final Kanji kanji;

    private final double count;

    private final boolean wantsDouble;

    public KanjiWithCounter(Kanji kanji, double count, boolean wantsDouble) {
        this.kanji = kanji;
        this.count = count;
        this.wantsDouble = wantsDouble;
    }

    public Kanji getKanji() {
        return kanji;
    }

    public double getCount() {
        return count;
    }

    public boolean isWantsDouble() {
        return wantsDouble;
    }

    @Override
    public String toString() {
        return "KanjiWithCounter [kanji=" + kanji + ", count=" + count + ", wantsDouble="
                + wantsDouble + "]";
    }

}
