package de.duehl.vocabulary.japanese.ui.creation.menu;

import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.common.data.VocabularySortOrder;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;

/**
 * Diese Klasse erzeugt das Vokabularien-Menü der graphischen Oberfläche des Vokabel-Trainers.
 *
 * @version 1.01     2024-03-20
 * @author Christian Dühl
 */

public class VocabularyMenuCreation implements SingleMenuCreation {

    /** Verbindung zur grafischen Oberfläche. */
    private final VocabularyTrainerGui gui;

    /**
     * Konstruktor.
     *
     * @param gui
     *            Verbindung zur grafischen Oberfläche.
     */
    public VocabularyMenuCreation(VocabularyTrainerGui gui) {
        this.gui = gui;
    }

    /** Erzeugt das Vokabularien-Menü. */
    @Override
    public JMenu createTheMenu() {
        JMenu menu = new JMenu("Vokabularien");
        menu.setMnemonic('a');

        for (VocabularySortOrder sortOrder : VocabularySortOrder.values()) {
            menu.add(createVocabularySortOrderMenuItem(sortOrder));
        }

        menu.addSeparator();

        menu.add(createToggleManualVocabularySortModeMenuItem());

        return menu;
    }

    private JMenuItem createVocabularySortOrderMenuItem(VocabularySortOrder sortOrder) {
        return new MyMenuItem("Vokabularien " + sortOrder.getDescription() + " sortieren")
                //.mnemonic('o')
                //.accelerator(KeyEvent.VK_F5, 0)
                .actionListener(e -> gui.setVocabularySortOrder(sortOrder));
    }

    private JMenuItem createToggleManualVocabularySortModeMenuItem() {
        return new MyMenuItem(
                "Modus zum individuellen Anordnen der Vokabulaien an- bzw. ausschalten")
                .mnemonic('m')
                .accelerator(KeyEvent.VK_F2, 0)
                .actionListener(e -> gui.toggleManualVocabularySortMode());
    }

}
