package de.duehl.vocabulary.japanese.ui.dialog.options.colors.vocable;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;

import javax.swing.JButton;
import javax.swing.JPanel;

import de.duehl.swing.persistance.ColorOptionUi;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.VocabularyTrainerVersion;
import de.duehl.vocabulary.japanese.common.persistence.Options;

/**
 * Diese Klasse erzeugt die grafische Oberfläche zur Bearbeitung der Farben zur Darstellung einer
 * Vokabel.
 *
 * @version 1.01     2024-12-07
 * @author Christian Dühl
 */

public class VocableColorsOptionsUi {

    /** Der Panel auf dem die Farben dargestellt werden. */
    private final JPanel panel;

    private ColorOptionUi vocableColorStandard;
    private ColorOptionUi vocableColorKanji;
    private ColorOptionUi vocableColorKana;
    private ColorOptionUi vocableColorTranslation;
    private ColorOptionUi vocableColorComment;
    private ColorOptionUi vocableColorSearchWords;
    private ColorOptionUi vocableColorPartOfSpeach;
    private ColorOptionUi vocableColorRomaji;
    private ColorOptionUi vocableColorPronunciation;

    /** Konstruktor. */
    public VocableColorsOptionsUi() {
        panel = new JPanel();
    }

    /** Initialisiert das Element mit den Farb-Einstellungen aus den Optionen. */
    public void initWithOptions(Options options) {
        initColorUis(options);
        buildPanel();

        panel.validate();
        panel.invalidate();
        panel.repaint();
    }

    private void initColorUis(Options options) {
        vocableColorStandard = new ColorOptionUi("Standard",
                options.getVocableColorStandard());
        vocableColorKanji = new ColorOptionUi("Kanji",
                options.getVocableColorKanji());
        vocableColorKana = new ColorOptionUi("Kana",
                options.getVocableColorKana());
        vocableColorRomaji = new ColorOptionUi("Romaji",
                options.getVocableColorRomaji());
        vocableColorPronunciation = new ColorOptionUi("Aussprache",
                options.getVocableColorPronunciation());
        vocableColorTranslation = new ColorOptionUi("Übersetzung",
                options.getVocableColorTranslation());
        vocableColorComment = new ColorOptionUi("Kommentar",
                options.getVocableColorComment());
        vocableColorSearchWords = new ColorOptionUi("Suchbegriff",
                options.getVocableColorSearchWords());
        vocableColorPartOfSpeach = new ColorOptionUi("Wortart",
                options.getVocableColorPartOfSpeach());
    }

    private void buildPanel() {
        panel.setLayout(new BorderLayout());

        panel.add(createColorsPart(), BorderLayout.CENTER);
        panel.add(createButtonPart(), BorderLayout.SOUTH);
    }

    private Component createColorsPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new VerticalLayout(5, VerticalLayout.BOTH)); // 3

        panel.add(vocableColorStandard.getPanel());
        panel.add(vocableColorKanji.getPanel());
        panel.add(vocableColorKana.getPanel());
        panel.add(vocableColorRomaji.getPanel());
        panel.add(vocableColorPronunciation.getPanel());
        panel.add(vocableColorTranslation.getPanel());
        panel.add(vocableColorComment.getPanel());
        panel.add(vocableColorSearchWords.getPanel());
        panel.add(vocableColorPartOfSpeach.getPanel());

        return panel;
    }

    private Component createButtonPart() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        panel.add(createToDefaultColorsButton(), BorderLayout.WEST);

        return panel;
    }

    private Component createToDefaultColorsButton() {
        JButton button = new JButton("Standardfarben");
        button.addActionListener(e -> toDefaultColors());
        return button;
    }

    private void toDefaultColors() {
        Options standardOptions = new Options(new VocabularyTrainerVersion().getVersion());

        vocableColorStandard.setColor(standardOptions.getVocableColorStandard());
        vocableColorKanji.setColor(standardOptions.getVocableColorKanji());
        vocableColorKana.setColor(standardOptions.getVocableColorKana());
        vocableColorRomaji.setColor(standardOptions.getVocableColorRomaji());
        vocableColorPronunciation.setColor(standardOptions.getVocableColorPronunciation());
        vocableColorTranslation.setColor(standardOptions.getVocableColorTranslation());
        vocableColorComment.setColor(standardOptions.getVocableColorComment());
        vocableColorSearchWords.setColor(standardOptions.getVocableColorSearchWords());
        vocableColorPartOfSpeach.setColor(standardOptions.getVocableColorPartOfSpeach());
    }

    /** Getter für den Panel auf dem die Farben dargestellt werden. */
    public JPanel getPanel() {
        return panel;
    }

    /** Getter für die Farbe für normalen Text bei der Darstellung einer Vokabel. */
    public Color getVocableColorStandard() {
        return vocableColorStandard.getColor();
    }
    /** Getter für die Farbe für Kanji bei der Darstellung einer Vokabel. */
    public Color getVocableColorKanji() {
        return vocableColorKanji.getColor();
    }

    /** Getter für die Farbe für Kana bei der Darstellung einer Vokabel. */
    public Color getVocableColorKana() {
        return vocableColorKana.getColor();
    }

    /** Getter für die Farbe für die Romaji bei der Darstellung einer Vokabel. */
    public Color getVocableColorRomaji() {
        return vocableColorRomaji.getColor();
    }

    /** Getter für die Farbe für die Aussprache bei der Darstellung einer Vokabel. */
    public Color getVocableColorPronunciation() {
        return vocableColorPronunciation.getColor();
    }

    /** Getter für die Farbe für die Übersetzung bei der Darstellung einer Vokabel. */
    public Color getVocableColorTranslation() {
        return vocableColorTranslation.getColor();
    }

    /** Getter für die Farbe für den Kommentar bei der Darstellung einer Vokabel. */
    public Color getVocableColorComment() {
        return vocableColorComment.getColor();
    }

    /** Getter für die Farbe für einen Suchbegriff bei der Darstellung einer Vokabel. */
    public Color getVocableColorSearchWords() {
        return vocableColorSearchWords.getColor();
    }

    /** Getter für die Farbe für eine Wortart bei der Darstellung einer Vokabel. */
    public Color getVocableColorPartOfSpeach() {
        return vocableColorPartOfSpeach.getColor();
    }

    /** Hinterlegt die Werte in den Optionen. */
    public void setIntoOptions(Options options) {
        options.setVocableColorStandard(getVocableColorStandard());
        options.setVocableColorKanji(getVocableColorKanji());
        options.setVocableColorKana(getVocableColorKana());
        options.setVocableColorTranslation(getVocableColorTranslation());
        options.setVocableColorComment(getVocableColorComment());
        options.setVocableColorSearchWords(getVocableColorSearchWords());
        options.setVocableColorPartOfSpeach(getVocableColorPartOfSpeach());
        options.setVocableColorRomaji(getVocableColorRomaji());
        options.setVocableColorPronunciation(getVocableColorPronunciation());
    }

}
