package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.addtolist;

import java.awt.Point;

import javax.swing.JPanel;

import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;

/**
 * Diese Klasse stellt einen Button bereit, um die angezeigte Vokabel zu einer eigenen Liste
 * hinzuzufügen.
 *
 * @version 1.01     2025-11-20
 * @author Christian Dühl
 */

public class VocableToOwnListAdderGui {

    /** Fügt eine Vokabel zu einer eigenen Liste hinzu. */
    private final VocableToOwnListAdder vocableToOwnListAdder;

    /** Stellt den Button wirklich dar. */
    private final VocableToOwnListAdderButtonCreator creator;

    /**
     * Konstruktor.
     *
     * @param vocable
     *            Die angezeigte Vokabel.
     * @param dataStructures
     *            Die Datenstrukturen des Vokabeltrainers.
     * @param uiObjects
     *            Die häufig verwendeten Funktionen der grafischen Oberfläche des Vokabeltrainers.
     * @param location
     *            Die Position des Rahmens der Oberfläche, die den Panel anzeigt, welcher diese
     *            Klasse verwendet.
     */
    public VocableToOwnListAdderGui(Vocable vocable, FumikoDataStructures dataStructures,
            FumikoUiObjects uiObjects, Point location) {
        vocableToOwnListAdder = new VocableToOwnListAdder(dataStructures, uiObjects, location);
        creator = new VocableToOwnListAdderButtonCreator(vocable, vocableToOwnListAdder);
    }

    /**
     * Fügt zum übergebenen Panel einen Button zur Anzeige der eigenen Listen an, welche die
     * Vokabel enthalten.
     *
     * @param panel
     *            Der Panel dem die Buttons hinzugefügt werden sollen. Dieser sollte ein Layout
     *            haben, das das Hinzufügen von Elemente ohne weitere Parameter gestattet, wie z.B.
     *            das VerticalLayout.
     */
    public void appendButtonToPanel(JPanel panel) {
        panel.add(creator.createAddVocableToListButton());
    }

}
