package de.duehl.vocabulary.japanese.ui.dialog.vocables.detail.related;

import java.awt.Component;

import javax.swing.JButton;

import de.duehl.vocabulary.japanese.data.Vocable;

/**
 * Diese Klasse stellt Buttons bereit, um zu einer veränderlichen Vokabel zugehörige Verb- und
 * Adjektivformen zu finden, wenn die Vokabel ein Verb bzw. ein Adjektiv ist.
 *
 * @version 1.01     2025-07-14
 * @author Christian Dühl
 */

class VerbAndAdjectiveButtonsCreator {

    /** Die Vokabel. */
    private final Vocable vocable;

    /** Findet zur angezeigten Vokabel gehörige Verb- und Adjektivformen. */
    private final VerbsAndAdjectivesFinder verbsAndAdjectivesFinder;

    /**
     * Konstruktor.
     *
     * @param vocable
     *            Die Vokabel.
     * @param verbsAndAdjectivesFinder
     *            Findet zur angezeigten Vokabel gehörige Verb- und Adjektivformen.
     */
    public VerbAndAdjectiveButtonsCreator(Vocable vocable,
            VerbsAndAdjectivesFinder verbsAndAdjectivesFinder) {
        this.vocable = vocable;
        this.verbsAndAdjectivesFinder = verbsAndAdjectivesFinder;
    }

    public Component createFindRelatedVerbsButton() {
        JButton button = new JButton("Liste von zugehörigen Verbformen anzeigen.");
        button.addActionListener(e -> findRelatedVerbs());
        return button;
    }

    private void findRelatedVerbs() {
        verbsAndAdjectivesFinder.findRelatedVerbs(vocable);
    }

    public Component createFindRelatedAdjectiveButton() {
        JButton button = new JButton("Liste von zugehörigen Adjektivformen anzeigen.");
        button.addActionListener(e -> findRelatedAdjectives());
        return button;
    }

    private void findRelatedAdjectives() {
        verbsAndAdjectivesFinder.findRelatedAdjectives(vocable);
    }

    public Component createFindRelatedVerbsButtonViaWoerterbuchform(Vocable woerterbuchform) {
        JButton button = new JButton(
                "Liste von zugehörigen Verbformen zur Wörterbuchform anzeigen.");
        button.addActionListener(e -> verbsAndAdjectivesFinder.findRelatedVerbs(woerterbuchform));
        return button;
    }

    public Component createFindRelatedAdjectiveButtonViaPositivePresence(
            Vocable positivePresence) {
        JButton button = new JButton(
                "Liste von zugehörigen Adjektivformen zur Grundform anzeigen.");
        button.addActionListener(
                e -> verbsAndAdjectivesFinder.findRelatedAdjectives(positivePresence));
        return button;
    }

}
